SELECT employee_lname AS 'Last name', employee_fname AS 'First name', department_name AS 'Department'
  FROM employees, departments
  WHERE employee_department = department_id
  ORDER BY employee_lname, employee_fname;

SELECT employee_lname AS 'Last name', employee_fname AS 'First name', department_name AS 'Department'
  FROM employees
  INNER JOIN departments
  ON employee_department = department_id
  ORDER BY employee_lname, employee_fname;

SELECT employee_lname AS 'Last name', employee_fname AS 'First name', department_name AS 'Department'
  FROM employees
  LEFT JOIN departments
  ON employee_department = department_id
  ORDER BY employee_lname, employee_fname;

SELECT department_name AS 'Department', employee_lname AS 'Last name', employee_fname AS 'First name'
  FROM employees
  RIGHT JOIN departments
  ON employee_department = department_id
  ORDER BY department_name, employee_lname, employee_fname;

SELECT department_name AS 'Department', employee_lname AS 'Last name', employee_fname AS 'First name'
  FROM employees
  LEFT JOIN departments
  ON employee_department = department_id
UNION SELECT department_name AS 'Department', employee_lname AS 'Last name', employee_fname AS 'First name'
  FROM employees
  RIGHT JOIN departments
  ON employee_department = department_id
ORDER BY 'Department', 'Last name', 'First name';

SELECT employee_lname AS 'Last name', employee_fname AS 'First name', department_name AS 'Department'
  FROM employees
  CROSS JOIN departments
  ORDER BY employee_lname, employee_fname;

---------------------------------------------------------------------------------------------------------------

SELECT a.employee_lname AS 'Employee last name', a.employee_fname AS 'Employee first name', b.employee_lname AS 'Manager last name', b.employee_fname AS 'Manager first name'
  FROM employees a, employees b
  WHERE a.employee_manager = b.employee_id
  ORDER BY a.employee_lname, a.employee_fname;

SELECT a.employee_lname AS 'Employee last name', a.employee_fname AS 'Employee first name', b.employee_lname AS 'Manager last name', b.employee_fname AS 'Manager first name'
  FROM employees a
  LEFT JOIN employees b
  ON a.employee_manager = b.employee_id
  ORDER BY a.employee_lname, a.employee_fname;
