segment code
..start:
        ; Initialization
        mov     ax, data
        mov     ds, ax
        mov     ax, stack
        mov     ss, ax
        mov     sp, stacktop
        ; Display text
        mov     dx, stext
        mov     ah, 09h
        int     21h
dowait:
        ; Wait for key pressed
        mov     ah, 00h
        int     16h
        ; Check if key pressed is ESC or F1 key
        cmp     al, keyesc
        je      exit
        cmp     al, 0
        jne     dowait
        cmp     ah, keyf1
        jne     dowait
        ; If key was F1 key, display start screen
        mov     dx, cls                ; clear screen
        mov     ah, 09h
        int     21h
        mov     dx, center             ; set cursor at center of screen
        mov     ah, 09h
        int     21h
        mov     ah, 02h                ; display the heart
        mov     dl, heart
        int     21h
        call    cursor_off             ; turn cursor off
doloop:
        ; Wait for key pressed
        mov     ah, 00h
        int     16h
        ; Check if key pressed is ESC
        cmp     al, keyesc
        je      exit
        ; Check for arrow keys
        cmp     al, 00h
        jne     doloop
        cmp     ah, keyleft
        je      arrow_left
        cmp     ah, keyrght
        je      arrow_right
        cmp     ah, keyup
        je      arrow_up
        cmp     ah, keydown
        je      arrow_down
        jmp     doloop
        ; Key was left arrow
arrow_left:
        mov     bl, [x]
        cmp     bl, 1
        je      doloop
        dec     bl
        mov     [x], bl
        mov     ax, left
        call    move_heart
        jmp     doloop
        ; Key was right arrow
arrow_right:
        mov     bl, [x]
        cmp     bl, 79
        je      doloop
        inc     bl
        mov     [x], bl
        mov     ax, right
        call    move_heart
        jmp     doloop
        ; Key was up arrow
arrow_up:
        mov     bl, [y]
        cmp     bl, 1
        je      doloop
        dec     bl
        mov     [y], bl
        mov     ax, up
        call    move_heart
        jmp     doloop
        ; Key was down arrow
arrow_down:
        mov     bl, [y]
        cmp     bl, 25
        je      doloop
        inc     bl
        mov     [y], bl
        mov     ax, down
        call    move_heart
        jmp     doloop
        ; Terminate program
exit:
        call    cursor_on              ; turn cursor on again
        mov     ax, 4c00h
        int     21h

; *
; * Subroutine:  Move the heart
; *   Input:  AX: address of cursor direction escape sequence
; *   Output: AX: destroyed
; *
move_heart:
        push    dx
        push    ax
        mov     ah, 02h
        mov     dl, bkspace
        int     21h
        mov     ah, 02h
        mov     dl, space
        int     21h
        mov     ah, 02h
        mov     dl, bkspace
        int     21h
        mov     ah, 09h
        pop     dx
        int     21h
        mov     ah, 02h
        mov     dl, heart
        int     21h
        pop     dx
        ret

; *
; * Subroutine:  Set cursor off
; *   Input:  --
; *   Output: --
; *
cursor_off:
        push    ax
        push    cx
        mov     ah, 01h                ; interrupt 10h function 01h (set cursor type)
        mov     ch, 1                  ; cursor starting line
        mov     cl, 0                  ; cursor ending line
        int     10h
        pop     cx
        pop     ax
        ret

; *
; * Subroutine:  Set cursor on (default cursor)
; *   Input:  --
; *   Output: --
; *
cursor_on:
        push    ax
        push    cx
        mov     ah, 01h                ; interrupt 10h function 01h (set cursor type)
        mov     ch, 6                  ; cursor starting line
        mov     cl, 7                  ; cursor ending line
        int     10h
        pop     cx
        pop     ax
        ret

segment data
space   equ     20h
bkspace equ     08h
heart   equ     03h
keyesc  equ     1bh
keyf1   equ     3bh
keyleft equ     4bh
keyrght equ     4dh
keyup   equ     48h
keydown equ     50h
stext   db      'Hit F1 to start, then use arrow keys to move the heart, or ESC to exit ', 13, 10, '$'
y       db      12
x       db      40
cls     db      1bh, '[2J', '$'
center  db      1bh, '[12;40H', '$'
left    db      1bh, '[1D', '$'
right   db      1bh, '[1C', '$'
up      db      1bh, '[1A', '$'
down    db      1bh, '[1B', '$'

segment stack   stack
        resb    64
stacktop:
