;
; Program sample 5: Random read
;

; Main program
; ============
segment code
..start:
        ; Initialization
        ; --------------
        mov     ax, data
        mov     ds, ax
        mov     ax, stack
        mov     ss, ax
        mov     sp, stacktop
        ; Open file
        ; ---------
        mov     ah, 3dh
        mov     al, 0                            ; open file as read
        mov     dx, fname
        int     21h
        jc      file_error1
        mov     [handle], ax
        ; Display amino acid at position entered by user
        ; until user input is empty
        ;-----------------------------------------------
loop_aa:
        ; Ask for position
        mov     dx, askpos
        mov     ah, 09h
        int     21h
        ; Get position from keyboard
        mov     dx, buffer
        mov     ah, 0ah
        int     21h
        mov     dx, newline
        mov     ah, 09h
        int     21h
        mov     cl, [poslen]
        cmp     cl, 0                            ; terminate program if no input
        je      done
        ; Convert ASCII to positive integer
        lea     esi, [pospos]                    ; first digit
        lea     edi, [pospos + 1]                ; second digit
        cmp     cl, 2
        je      convert
        mov     al, [esi]                        ; make 2-digit number
        mov     [edi], al
        mov     byte [esi], '0'
convert:
        xor     ax, ax
        mov     al, [esi]
        sub     al, 30h                          ; '0' = ASCII 30h
        mov     bl, 10
        imul    bl                               ; first digit * 10
        xor     bx, bx
        mov     bl, [edi]
        sub     bl, 30h                          ; '0' = ASCII 30h
        add     ax, bx                           ; second digit as such
        cmp     ax, 1                            ; position must be >= 1
        jl      invalid_1
        cmp     ax, seqlen                       ; position must be <= sequence length
        jg      invalid_2
        dec     ax                               ; first record = 0
        mov     bx, 3                            ; file position = aa position * aa code length (3)
        imul    bx
        ; Set file position
        mov     cx, 0                            ; CX:DX is offset in file
        mov     dx, ax
        mov     ah, 42h
        mov     al, 0                            ; begin of file position
        mov     bx, [handle]
        int     21h
        jc      file_error2
        ; Read amino acid at this position
        mov     ah, 3fh
        mov     bx, [handle]
        mov     cx, 3                            ; 3-letter amino acid code
        mov     dx, amacid
        int     21h
        jc      file_error3
        ; Display this amino acid
        mov     ah, 09h
        mov     dx, amacid
        int     21h
        jmp     loop_aa
        ; Invalid position (< 1)
        ; ----------------------
invalid_1:
        mov     dx, poserr1
        mov     ah, 09h
        int     21h
        jmp     loop_aa
        ; Invalid position (> seqlen)
        ; ---------------------------
invalid_2:
        mov     dx, poserr2
        mov     ah, 09h
        int     21h
        jmp     loop_aa
        ; Open file error
        ; ---------------
file_error1:
        mov     dx, ferror1
        mov     ah, 09h
        int     21h
        jmp     exit
        ; Seek file error
        ; ----------------
file_error2:
        mov     dx, ferror2
        mov     ah, 09h
        int     21h
        jmp     done
        ; Read file error
        ; ---------------
file_error3:
        mov     dx, ferror3
        mov     ah, 09h
        int     21h
        jmp     done
        ; Close the file
        ; --------------
done:
        mov     bx, [handle]
        mov     ah, 3eh
        int     21h
        ; Terminate the program
        ; ---------------------
exit:
        mov     ax, 4c00h
        int     21h

; Data segment
; ============
segment data
seqlen  equ     51
maxlen  equ     2
fname   db      'INSULINE.TXT', 00h
askpos  db      'Amino acid position in insuline sequence? ', '$'
poserr1 db      'Invalid position!', 13, 10, '$'
poserr2 db      'Sequence has only 51 amino acids!', 13, 10, '$'
ferror1 db      'Error when opening file!', 13, 10, '$'
ferror2 db      'Error when setting file position!', 13, 10, '$'
ferror3 db      'Error when reading from file!', 13, 10, '$'
amacid  resb    3
newline db      13, 10, '$'
handle  resb    2
buffer  db      maxlen + 1
poslen  resb    1
pospos  resb    maxlen + 1


; Stack segment
; =============
segment stack   stack
        resb    64
stacktop:
