;
; Program sample 2: Read from file
;

; Main program
; ============
segment code
..start:
        ; Initialization
        ; --------------
        mov     ax, data
        mov     ds, ax
        mov     ax, stack
        mov     ss, ax
        mov     sp, stacktop
        ; Open the file
        ; -------------
        mov     ah, 3dh
        mov     al, 0
        mov     dx, fname
        int     21h
        jc      file_error1
        mov     [handle], ax
        ; Read insuline chain A from the file, and display it
        ; ---------------------------------------------------
read_sequence:
        mov     byte [count], 0
        ; Read one amino acid
read_aa:
        mov     ah, 3fh
        mov     bx, [handle]
        mov     cx, 3
        mov     dx, amacid
        int     21h
        jc      file_error2
        test    ax, ax                           ; end-of-file
        jz      done
        ; Display this amino acid
        mov     ah, 09h
        mov     dx, amacid
        int     21h
        ; Line break after each 10 amino acids
        mov     cl, [count]
        inc     cl
        mov     [count], cl
        cmp     cl, 10
        jl      read_aa
        mov     dx, newline
        mov     ah, 09h
        int     21h
        jmp     read_sequence
        ; Open file error
        ; ---------------
file_error1:
        mov     dx, ferror1
        mov     ah, 09h
        int     21h
        jmp     exit
        ; Read file error
        ; ---------------
file_error2:
        mov     dx, ferror2
        mov     ah, 09h
        int     21h
        jmp     done
        ; Close the file
        ; --------------
done:
        mov     bx, [handle]
        mov     ah, 3eh
        int     21h
        ; Terminate the program
        ; ---------------------
exit:
        mov     ax, 4c00h
        int     21h

; Data segment
; ============
segment data
fname   db      'INSULINE.TXT', 00h
ferror1 db      'Error when opening file!', 13, 10, '$'
ferror2 db      'Error when reading from file!', 13, 10, '$'
amacid  db      'XXX'
        db      ' '
        db      '$'
newline db      13, 10, '$'
handle  resb    2
count   resb    1

; Stack segment
; =============
segment stack   stack
        resb    64
stacktop:
