;
; Program sample 1: Create a new file
;

; Main program
segment code
..start:
        ; Initialization
        mov     ax, data
        mov     ds, ax
        mov     ax, stack
        mov     ss, ax
        mov     sp, stacktop
        ; Enter filename until no input
do_loop:
        ; Ask for filename
        mov     dx, askfn
        mov     ah, 09h
        int     21h
        ; Get filename from keyboard
        mov     dx, buffer
        mov     ah, 0ah
        int     21h
        mov     cl, [buffer + 1]       ; length of input
        cmp     cl, 0
        je      exit                   ; exit if no filename
        ; Copy input
        lea     esi, [buffer + 2]      ; start of input text
        lea     edi, [fname]           ; copy destination
copy_char:
        mov     bl, [esi]
        mov     [edi], bl
        inc     esi
        inc     edi
        dec     cl
        test    cl, cl
        jnz     copy_char
        mov     byte [edi], 00h        ; add null-terminator
        ; Try to open the file
        mov     ah, 3dh
        mov     al, 0
        mov     dx, fname
        int     21h
        jc      continue
        ; File already exists
        mov     [handle], ax
        mov     dx, exists
        mov     ah, 09h
        int     21h
        call    close_file
        jmp     do_loop
continue:
        ; Create the new file
        mov     ah, 3ch
        mov     cx, 0
        mov     dx, fname
        int     21h
        jc      file_error
        mov     [handle], ax
        mov     dx, success
        mov     ah, 09h
        int     21h
        call    close_file
        jmp     do_loop
        ; File error
file_error:
        mov     dx, ferror1
        mov     ah, 09h
        int     21h
        jmp     do_loop
        ; Terminate the program
exit:
        mov     dx, newline
        mov     ah, 09h
        int     21h
        mov     ax, 4c00h
        int     21h

; Subroutine: Close the file
close_file:
        mov     bx, [handle]
        mov     ah, 3eh
        int     21h
        jnc     return
        mov     dx, ferror2
        mov     ah, 09h
        int     21h
return:
        ret

; Data segment
segment data
maxlen  equ     25
askfn   db      'Filename? ', '$'
success db      13, 10, 'File successfully created!', 13, 10, '$'
exists  db      13, 10, 'File already exists!', 13, 10, '$'
ferror1 db      13, 10, 'Error when creating file!', 13, 10, '$'
ferror2 db      13, 10, 'Error when closing file!', 13, 10, '$'
newline db      13, 10, '$'
buffer  db      maxlen + 1
        resb    maxlen + 2
fname   db      maxlen + 1
handle  resb    2

; Stack segment
segment stack   stack
        resb    64
stacktop:
